#ifndef SGAFFICHAGE_H
#define SGAFFICHAGE_H

#define g_SGAffichage SGAffichage::getSGAffichage()

#include "allegro.h"
#include <stdio.h>
#include "SGentite.h"
#include "SGTimer.h"

typedef enum ModeAffichage { WINDOWED, FULLSCREEN };
typedef enum TypeAffichage { DOUBLEBUFFERING, TRIPLEBUFFERING, PAGEFLIPING };

class SGAffichage
{
    private:
        // Pointeur statique de la classe SGAffichage permettant d'utiliser la classe
        // en tant que singleton
        static SGAffichage *m_pSGAffichage;
        // Ce sont la hauteur et la largeur de l'cran, c'est  dire la rsolution du jeu
        short int m_iHauteur,m_iLargeur;
        // Nombre de bits par pixels
        char m_cCouleur;
        // Ce sont des images permettant d'utiliser les 3 types d'affichage diffrents
        // Le DoubleBuffering utilise un seul bitmap
        // Le PageFlippling utilise deux bitmaps
        // Le TrippleBuffering utilise les 3 bitmaps
        BITMAP *m_pTemp[3];
        // Variable indiquant le bitmap qui doit etre afficher durant la boucle du moteur
        int m_iPage;
        // Enumration indiquant  l'application si elle doit tourner en mode fentr ou plein
        // cran
        ModeAffichage m_Mode;
        // Enumration indiquant le type d'affichage de l'application : DOUBLEBUFFERING, 
        // TRIPLEBUFFERING ou PAGEFLIPING
        TypeAffichage m_Type;
        // Variable pour afficher le temps du jeu en ms
        bool m_bTemps;
        // Variable pour afficher le nombre d'images par secondes
        bool m_bFps;
        // Compteur servant pour calculer les images par secondes ( FPS )
        int m_iCptFps;
        // Nombre d'images par secondes ( FPS )
        int m_iFps;        
        // Table des couleurs transparentes
        COLOR_MAP m_transTable;
        // Table des couleurs RGB
        RGB_MAP rgb_table;
    public:
        // Ne pas utiliser !!
        SGAffichage();
        // Constructeur qui prend en argument la largeur et la hauteur de la rsolution que l'on dsire.
        // Le prochain argument est le nombre de bits par couleur
        // mode permet de choisir entre le mode fentr ou plein cran
        // type permet de choisir la maniere dont va tre affiche l'application : double, triple buffering
        // ou pageflipping
        // Le constructeur initialise aussi certaines variables  0
        SGAffichage(const short int iLargeur,const short int iHauteur,const char cCouleur,
                                                ModeAffichage mode,TypeAffichage type);
        // Le destructeur a pour role de dtruire le tableau d'images servant pour le type d'affichage
        ~SGAffichage();
        // C'est l'accesseur du pointeur statique permettant d'accder aux fonctions de la classe
        static SGAffichage  &getSGAffichage() { return *m_pSGAffichage ; }
        // Permet d'afficher dans le bitmap temporaire un sprite prsent dans la liste d'entits
        void chargerSprite(char *szNom);
        // Permet d'afficher tous les sprites de la liste d'entits dans le bitmap temporaire
        void chargerSprites();
        // Remplit de noir (0,0,0) le bitmap temporaire
        void effacerTout();
        // Permet d'afficher  l'cran le bitmap temporaire ainsi que des informations tel que
        // les images par seconde ou le temps coul en millisecondes
        void afficherTout();
        // Initialise le nombre de bits par pixel, cr en mmoire les bitmaps(images) ncssaires
        // et initialise aussi la transparence
        void initialiser();
        // Permet d'afficher  l'cran une chaine de caractres aux coordonnes iX et iY avec la 
        // couleur color
        void afficherTexte(char *szTexte,const int iX,const int iY,const int color);
        // Indique au singleton que le temps doit tre affich
        void afficherTemps() { m_bTemps=true ; }
        // Indique au singleton que le temps ne doit tre affich
        void effacerTemps() { m_bTemps=false ; }
        // Affiche le temps dans le bitmap temporaire
        void chargerTemps();
        // Indique au singleton que les images par secondes doivent tre affiches
        void afficherFps();
        // Indique au singleton que les images par secondes ne doivent pas tre affiches
        void effacerFps();
        // Affiche les images par secondes dans le bitmap temporaire
        void chargerFps();
        // Fonction qui permet de lancer l'animation de chaque sprite prsent dans la liste
        // d'entits
        void animerSprites();
        
        void afficherEntier(const int iEntier,const int iX,const int iY,const int iColor);
};

#endif
